library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;
use work.SHA256_PACKAGE.all;

entity S1_BLOCK is
	port( X : in std_logic_vector(31 downto 0);
		  O : out std_logic_vector(31 downto 0));
end S1_BLOCK;

architecture BEHAVIORAL of S1_BLOCK is

	signal ROR17 : std_logic_vector(31 downto 0);
	signal ROR19 : std_logic_vector(31 downto 0);
	signal SHR10 : std_logic_vector(31 downto 0);

begin

	ROR17 <= X(16 downto 0) & X(31 downto 17);
	ROR19 <= X(18 downto 0) & X(31 downto 19);
	SHR10 <= "0000000000" & X(31 downto 10);

	O <= ROR17 xor ROR19 xor SHR10;

end BEHAVIORAL;